<?php
/**
 * The public-facing functionality of the plugin.
 *
 * @since      1.0.0
 */
class AR_Display_Public {

    /**
     * The ID of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $plugin_name    The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $version    The current version of this plugin.
     */
    private $version;

    /**
     * Initialize the class and set its properties.
     *
     * @since    1.0.0
     * @param    string    $plugin_name       The name of this plugin.
     * @param    string    $version    The version of this plugin.
     */
    public function __construct($plugin_name, $version) {
        $this->plugin_name = $plugin_name;
        $this->version = $version;
    }

    /**
     * Register the stylesheets for the public-facing side of the site.
     *
     * @since    1.0.0
     */
    public function enqueue_styles() {
        wp_enqueue_style(
            $this->plugin_name,
            AR_DISPLAY_PLUGIN_URL . '/assets/css/ardisplay-public.css',
            array(),
            $this->version,
            'all'
        );
    }

    /**
     * Register the JavaScript for the public-facing side of the site.
     *
     * @since    1.0.0
     */
    public function enqueue_scripts() {
        wp_enqueue_script(
            $this->plugin_name,
            AR_DISPLAY_PLUGIN_URL . '/assets/js/ardisplay-public.js',
            array('jquery'),
            $this->version,
            false
        );
    }
    
    /**
     * Process the ARDISPLAY shortcode.
     *
     * @since    1.0.0
     * @param    array     $atts    Shortcode attributes.
     * @return   string             HTML output for the shortcode.
     */
    public function ardisplay_shortcode($atts) {
        // Default attributes
        $atts = shortcode_atts(
            array(
                'title' => 'ARDISPLAY Content',
                'display_type' => 'default',
            ),
            $atts,
            'ardisplay'
        );
        
        // Start output buffering
        ob_start();
        
        // Include the partial template
        include AR_DISPLAY_PLUGIN_DIR . 'public/partials/ardisplay-public-display.php';
        
        // Get the buffered content and return it
        return ob_get_clean();
    }
}
