/**
 * JavaScript for the 3D Models table page
 */
jQuery(document).ready(function($) {
    // Handle per_page change
    $('.tablenav-pages select.per-page').on('change', function() {
        $(this).closest('form').submit();
    });
    
    // Handle delete button click
    $(document).on('click', '.ardisplay-delete-model', function(e) {
        e.preventDefault();
        
        // Get the model ID
        const modelId = $(this).data('model-id');
        
        // Store the model ID for deletion
        $('#ardisplay-delete-model-modal').data('model-id', modelId);
        
        // Show the confirmation modal
        $('#ardisplay-delete-model-modal').show();
    });
     
    $(document).on('click', '.previewBtn', function(e) {
        e.preventDefault();
        
        // Get the model ID
        const modelId = $(this).data('url');

        window.showPreviewModal(url);

    });


    
    // Handle cancel delete
    $('.ardisplay-cancel-delete').on('click', function() {
        // Hide the modal
        $('#ardisplay-delete-model-modal').hide();
    });
    
    // Handle confirm delete
    $('.ardisplay-confirm-delete').on('click', function() {
        // Get the model ID
        const modelId = $('#ardisplay-delete-model-modal').data('model-id');
        
        // Show loading state
        $(this).text('Deleting...').prop('disabled', true);
        $('.ardisplay-cancel-delete').prop('disabled', true);
        
        // Send AJAX request to delete the model
        $.ajax({
            url: ardisplayModelsData.ajaxurl,
            type: 'POST',
            data: {
                action: 'ardisplay_delete_model',
                model_id: modelId,
                nonce: ardisplayModelsData.nonce
            },
            success: function(response) {
                // Hide the modal
                $('#ardisplay-delete-model-modal').hide();
                
                if (response.success) {
                    // Remove the row from the table
                    $('tr[data-model-id="' + modelId + '"]').fadeOut(300, function() {
                        $(this).remove();
                        
                        // If no more rows, show the "no models" message
                        if ($('.wp-list-table tbody tr').length === 0) {
                            $('.wp-list-table tbody').html(
                                '<tr class="no-items"><td class="colspanchange" colspan="7">' + 
                                'No 3D models found.</td></tr>'
                            );
                        }
                        
                        // Update the count in the top bar
                        updateModelCount(-1);
                    });
                    
                    // Show success message
                    if (typeof ardisplayToastrSuccess !== 'undefined') {
                        ardisplayToastrSuccess(response.data.message);
                    } else {
                        alert(response.data.message);
                    }
                } else {
                    // Show error message
                    if (typeof ardisplayToastrError !== 'undefined') {
                        ardisplayToastrError(response.data.message);
                    } else {
                        alert(response.data.message);
                    }
                }
            },
            error: function() {
                // Hide the modal
                $('#ardisplay-delete-model-modal').hide();
                
                // Show error message
                if (typeof ardisplayToastrError !== 'undefined') {
                    ardisplayToastrError('An error occurred while deleting the model.');
                } else {
                    alert('An error occurred while deleting the model.');
                }
            },
            complete: function() {
                // Reset button state
                $('.ardisplay-confirm-delete').text('Delete').prop('disabled', false);
                $('.ardisplay-cancel-delete').prop('disabled', false);
            }
        });
    });
    
    // Close modal when clicking outside
    $(window).on('click', function(e) {
        if ($(e.target).is('#ardisplay-delete-model-modal')) {
            $('#ardisplay-delete-model-modal').hide();
        }
    });
    
    // Handle toggle status click
    $(document).on('click', '.ardisplay-status', function() {
        const $row = $(this).closest('tr');
        const modelId = $row.attr('data-model-id');
        const currentStatus = modelId !== null && $(this).hasClass('ardisplay-status-enabled');
        const newStatus = !currentStatus;
        const $statusElement = $(this);

        console.log(modelId, newStatus);
        
        // Show loading state
        const originalText = $statusElement.text();
        $statusElement.text('Updating...');
        
        // Send AJAX request to update status
        $.ajax({
            url: ardisplayModelsData.ajaxurl,
            type: 'POST',
            data: {
                action: 'ardisplay_toggle_model_status',
                model_id: modelId,
                enabled: newStatus,
                nonce: ardisplayModelsData.nonce
            },
            success: function(response) {
                if (response.success) {
                    // Update status display
                    if (newStatus) {
                        $statusElement.removeClass('ardisplay-status-disabled').addClass('ardisplay-status-enabled');
                        $statusElement.text('Enabled');
                    } else {
                        $statusElement.removeClass('ardisplay-status-enabled').addClass('ardisplay-status-disabled');
                        $statusElement.text('Disabled');
                    }
                    
                    // Show success message
                    if (typeof ardisplayToastrSuccess !== 'undefined') {
                        ardisplayToastrSuccess(response.data.message);
                    } else {
                        alert(response.data.message);
                    }
                } else {
                    // Revert to original text
                    $statusElement.text(originalText);
                    
                    // Show error message
                    if (typeof ardisplayToastrError !== 'undefined') {
                        ardisplayToastrError(response.data.message);
                    } else {
                        alert(response.data.message);
                    }
                }
            },
            error: function() {
                // Revert to original text
                $statusElement.text(originalText);
                
                // Show error message
                if (typeof ardisplayToastrError !== 'undefined') {
                    ardisplayToastrError('An error occurred while updating the status.');
                } else {
                    alert('An error occurred while updating the status.');
                }
            }
        });
    });
    
    // Handle the toggle-row button for responsive views
    $(document).on('click', '.toggle-row', function() {
        $(this).closest('tr').toggleClass('is-expanded');
    });
    
    // Function to update the model count in the list view
    function updateModelCount(change) {
        // Update the count in .displaying-num
        const $count = $('.tablenav-pages .displaying-num');
        if ($count.length) {
            const countText = $count.text();
            const matches = countText.match(/(\d+)/);
            if (matches && matches[1]) {
                const currentCount = parseInt(matches[1], 10);
                const newCount = currentCount + change;
                
                if (newCount === 1) {
                    $count.text('1 item');
                } else {
                    $count.text(newCount + ' items');
                }
            }
        }
    }

   
});
