<?php
/**
 * This file contains function declarations for WordPress core functions to help IDE recognize them
 * and eliminate linting errors. This file is not meant to be included in the actual plugin.
 * 
 * @package ARDisplay
 */

// WordPress Plugin API
if (!function_exists('add_action')) {
    function add_action($hook_name, $callback, $priority = 10, $accepted_args = 1) {}
}

if (!function_exists('add_filter')) {
    function add_filter($hook_name, $callback, $priority = 10, $accepted_args = 1) {}
}

if (!function_exists('apply_filters')) {
    function apply_filters($hook_name, $value) {}
}

// WordPress Admin API
if (!function_exists('add_menu_page')) {
    function add_menu_page($page_title, $menu_title, $capability, $menu_slug, $function = '', $icon_url = '', $position = null) {}
}

if (!function_exists('add_submenu_page')) {
    function add_submenu_page($parent_slug, $page_title, $menu_title, $capability, $menu_slug, $function = '', $position = null) {}
}

// WordPress Script and Style API
if (!function_exists('wp_enqueue_script')) {
    function wp_enqueue_script($handle, $src = '', $deps = array(), $ver = false, $in_footer = false) {}
}

if (!function_exists('wp_enqueue_style')) {
    function wp_enqueue_style($handle, $src = '', $deps = array(), $ver = false, $media = 'all') {}
}

if (!function_exists('wp_localize_script')) {
    function wp_localize_script($handle, $object_name, $l10n) {}
}

if (!function_exists('wp_create_nonce')) {
    function wp_create_nonce($action = -1) {}
}

if (!function_exists('wp_verify_nonce')) {
    function wp_verify_nonce($nonce, $action = -1) {}
}

if (!function_exists('wp_enqueue_media')) {
    function wp_enqueue_media($args = array()) {}
}

// WordPress HTTP API
if (!function_exists('wp_remote_get')) {
    function wp_remote_get($url, $args = array()) {}
}

if (!function_exists('wp_remote_post')) {
    function wp_remote_post($url, $args = array()) {}
}

if (!function_exists('wp_remote_retrieve_response_code')) {
    function wp_remote_retrieve_response_code($response) {}
}

if (!function_exists('wp_remote_retrieve_body')) {
    function wp_remote_retrieve_body($response) {}
}

if (!function_exists('is_wp_error')) {
    function is_wp_error($thing) {}
}

// WordPress Option API
if (!function_exists('get_option')) {
    function get_option($option, $default = false) {}
}

if (!function_exists('update_option')) {
    function update_option($option, $value, $autoload = null) {}
}

// WordPress Post API
if (!function_exists('update_post_meta')) {
    function update_post_meta($post_id, $meta_key, $meta_value, $prev_value = '') {}
}

if (!function_exists('get_post_meta')) {
    function get_post_meta($post_id, $key = '', $single = false) {}
}

// WordPress Formatting API
if (!function_exists('sanitize_text_field')) {
    function sanitize_text_field($str) {}
}

if (!function_exists('absint')) {
    function absint($maybeint) {}
}

if (!function_exists('esc_url')) {
    function esc_url($url, $protocols = null, $_context = 'display') {}
}

if (!function_exists('esc_html')) {
    function esc_html($text) {}
}

if (!function_exists('esc_attr')) {
    function esc_attr($text) {}
}

// WordPress Translation API
if (!function_exists('__')) {
    function __($text, $domain = 'default') {}
}

if (!function_exists('_e')) {
    function _e($text, $domain = 'default') {}
}

// WordPress URL API
if (!function_exists('admin_url')) {
    function admin_url($path = '', $scheme = 'admin') {}
}

if (!function_exists('plugin_dir_url')) {
    function plugin_dir_url($file) {}
}

if (!function_exists('get_site_url')) {
    function get_site_url($blog_id = null, $path = '', $scheme = null) {}
}

// WordPress AJAX API
if (!function_exists('wp_send_json_success')) {
    function wp_send_json_success($data = null) {}
}

if (!function_exists('wp_send_json_error')) {
    function wp_send_json_error($data = null, $status_code = null) {}
}

if (!function_exists('wp_die')) {
    function wp_die($message = '', $title = '', $args = array()) {}
}

// WordPress Screen API
if (!function_exists('get_current_screen')) {
    function get_current_screen() {}
}
