<?php
/**
 * WooCommerce Product listing admin page for ARDISPLAY - Configure ARt Previews
 *
 * @since      1.0.0
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}



// Check if WooCommerce is active
if (!class_exists('WooCommerce')) {
    ?>
    <div class="wrap">
        <h1><?php echo esc_html__('Configure ARt Previews', 'ardisplay'); ?></h1>
        <div class="notice notice-error">
            <p><?php echo esc_html__('This feature requires WooCommerce to be installed and activated.', 'ardisplay'); ?></p>
        </div>
        <p>
            <a href="<?php echo esc_url(admin_url('plugin-install.php?s=woocommerce&tab=search&type=term')); ?>" class="button button-primary">
                <?php echo esc_html__('Install WooCommerce', 'ardisplay'); ?>
            </a>
        </p>
    </div>
    <?php
    return;
}

// Create an instance of our product list table
$products_list_table = new AR_Display_Product_List_Table();
$products_list_table->prepare_items();
?>

<div class="wrap">
    <div style="display: flex; justify-content: space-between; align-items: center;">
        <h1 class="wp-heading-inline"><?php echo esc_html__('Configure ARt Previews', 'ardisplay'); ?></h1>
        <a href="<?php echo esc_url(admin_url('post-new.php?post_type=product')); ?>" class="page-title-action"><?php echo esc_html__('Add New Product', 'ardisplay'); ?></a>
    </div>
    <hr class="wp-header-end">
    
    <div class="notice notice-info">
        <p><?php echo esc_html__('Configure AR previews for your WooCommerce products. This allows customers to visualize products in augmented reality before purchasing.', 'ardisplay'); ?></p>
    </div>
    
    <form id="ardisplay-products-filter" method="post">
        <?php
        // Add search box
        $products_list_table->search_box(__('Search Products', 'ardisplay'), 'ardisplay-product-search');
        
        // Display the table
        $products_list_table->display();
        ?>
    </form>
</div>
<?php
    // Enqueue required scripts
    if (function_exists('wp_enqueue_script')) {
        wp_enqueue_script('ardisplay-admin-table', AR_DISPLAY_PLUGIN_URL . 'admin/js/ardisplay-table.js', array('jquery'), '1.0.0', true);
    }

