<?php

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Render the admin page content
 */
function ardisplay_home_admin_page() {
    // Generate a unique iframe ID
    $iframe_id = 'ardisplay_iframe_' . uniqid();
    
    // Add admin URLs that we'll need for navigation
    $api_settings_url = admin_url('admin.php?page=ardisplay-license');
    $products_url = admin_url('admin.php?page=display-products-page');
    $integration_url = admin_url('admin.php?page=display-products-page');
    ?>
    <div class="">
        <iframe id="<?php echo $iframe_id; ?>" style="width: 100%; height: 100vh; border: none; margin: 0; padding: 0;"></iframe>
        
        <script>
        (function() {
            try {
                // Get the iframe element
                var iframe = document.getElementById('<?php echo $iframe_id; ?>');
                
                // Create the iframe content
                var iframeContent = `
                    <!DOCTYPE html>
                    <html>
                    <head>
                        <meta charset="UTF-8">
                        <meta name="viewport" content="width=device-width, initial-scale=1.0">
                        <title>AR Display</title>
                        <style>
                            /* Reset styles */
                            * {
                                margin: 0;
                                padding: 0;
                                box-sizing: border-box;
                            }
                            
                            /* Variables */
                            :root {
                                --primary-color: #4f46e5;
                                --primary-light: #ede9fe;
                                --primary-dark: #3730a3;
                                --secondary-color: #06b6d4;
                                --accent-color: #f59e0b;
                                --success-color: #10b981;
                                --warning-color: #fbbf24;
                                --danger-color: #ef4444;
                                --text-color: #1e293b;
                                --text-light: #64748b;
                                --text-xlight: #94a3b8;
                                --background-light: #f8fafc;
                                --background-hover: #f1f5f9;
                                --border-color: #e2e8f0;
                                --border-radius-sm: 8px;
                                --border-radius-md: 12px;
                                --border-radius-lg: 16px;
                                --border-radius-xl: 24px;
                                --shadow-sm: 0 2px 4px rgba(0, 0, 0, 0.05);
                                --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
                                --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
                                --shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
                                --shadow-inner: inset 0 2px 4px 0 rgba(0, 0, 0, 0.06);
                                --transition-fast: 0.15s;
                                --transition-medium: 0.3s;
                                --transition-slow: 0.5s;
                                --font-size-xs: 0.75rem;
                                --font-size-sm: 0.875rem;
                                --font-size-md: 1rem;
                                --font-size-lg: 1.125rem;
                                --font-size-xl: 1.25rem;
                                --font-size-2xl: 1.5rem;
                                --font-size-3xl: 1.875rem;
                                --font-size-4xl: 2.25rem;
                                --font-size-5xl: 3rem;
                                --font-size-6xl: 3.75rem;
                                --spacing-1: 0.25rem;
                                --spacing-2: 0.5rem;
                                --spacing-3: 0.75rem;
                                --spacing-4: 1rem;
                                --spacing-5: 1.25rem;
                                --spacing-6: 1.5rem;
                                --spacing-8: 2rem;
                                --spacing-10: 2.5rem;
                                --spacing-12: 3rem;
                                --spacing-16: 4rem;
                                --spacing-20: 5rem;
                                --spacing-24: 6rem;
                            }
                            
                            body {
                                font-family: "Inter var", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
                                color: var(--text-color);
                                background-color: #fff;
                                line-height: 1.5;
                                padding: 20px;
                            }
                            
                            .ar-app-container {
                                margin: 0 auto;
                            }
                            
                            /* Hero section */
                            .hero-section {
                                position: relative;
                                border-radius: var(--border-radius-xl);
                                color: white;
                                padding: var(--spacing-16) var(--spacing-10);
                                margin-bottom: var(--spacing-24);
                                overflow: hidden;
                                background: linear-gradient(145deg, #4f46e5, #7c3aed, #8b5cf6);
                                box-shadow: var(--shadow-xl);
                                display: flex;
                                flex-wrap: wrap;
                                align-items: center;
                                justify-content: space-between;
                                z-index: 1;
                            }
                            
                            /* Animated background elements */
                            .hero-section::before {
                                content: "";
                                position: absolute;
                                width: 100%;
                                height: 100%;
                                top: 0;
                                left: 0;
                                background: 
                                    radial-gradient(circle at 20% 30%, rgba(139, 92, 246, 0.8) 0%, transparent 50%),
                                    radial-gradient(circle at 80% 70%, rgba(124, 58, 237, 0.8) 0%, transparent 50%);
                                z-index: -1;
                            }
                            
                            /* Floating particle background */
                            .hero-section::after {
                                content: "";
                                position: absolute;
                                top: 0;
                                left: 0;
                                width: 100%;
                                height: 100%;
                                background-image: url("data:image/svg+xml,%3Csvg width='100' height='100' viewBox='0 0 100 100' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M11 18c3.866 0 7-3.134 7-7s-3.134-7-7-7-7 3.134-7 7 3.134 7 7 7zm48 25c3.866 0 7-3.134 7-7s-3.134-7-7-7-7 3.134-7 7 3.134 7 7 7zm-43-7c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zm63 31c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zM34 90c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zm56-76c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zM12 86c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm28-65c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm23-11c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm-6 60c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm29 22c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zM32 63c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm57-13c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm-9-21c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM60 91c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM35 41c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM12 60c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2z' fill='%23ffffff' fill-opacity='0.1' fill-rule='evenodd'/%3E%3C/svg%3E");
                                opacity: 0.5;
                                z-index: -1;
                                animation: float 120s linear infinite;
                            }

                            .hero-content {
                                flex: 1;
                                min-width: 300px;
                                z-index: 2;
                                max-width: 600px;
                                animation: fadeInUp 0.8s ease-out;
                            }
                            
                            .hero-section h1 {
                                font-size: var(--font-size-5xl);
                                font-weight: 800;
                                margin-bottom: var(--spacing-6);
                                line-height: 1.2;
                                background: linear-gradient(to right, #ffffff, #e2e8f0);
                                -webkit-background-clip: text;
                                background-clip: text;
                                -webkit-text-fill-color: transparent;
                                letter-spacing: -0.025em;
                                text-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
                            }
                            
                            .hero-section p {
                                font-size: var(--font-size-xl);
                                line-height: 1.6;
                                margin-bottom: var(--spacing-8);
                                text-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
                                opacity: 0.9;
                                font-weight: 500;
                            }
                            
                            .hero-buttons {
                                display: flex;
                                gap: var(--spacing-4);
                                margin-top: var(--spacing-8);
                            }
                            
                            .ar-action-button.primary {
                                background-color: white;
                                color: var(--primary-color);
                                padding: 12px 24px;
                                border-radius: 8px;
                                font-weight: 600;
                                border: none;
                                cursor: pointer;
                                transition: all 0.2s;
                                box-shadow: var(--shadow-md);
                                font-size: 16px;
                            }
                            
                            .ar-action-button.primary:hover {
                                transform: translateY(-2px);
                                box-shadow: var(--shadow-lg);
                            }
                            
                            .hero-graphic {
                                flex: 1;
                                min-width: 300px;
                                display: flex;
                                justify-content: center;
                                align-items: center;
                                z-index: 2;
                                animation: floatingDevice 6s ease-in-out infinite, fadeIn 1s ease-out;
                            }
                            
                            .ar-phone-mockup {
                                position: relative;
                                width: 300px;
                                height: 600px;
                                background: rgba(255, 255, 255, 0.1);
                                backdrop-filter: blur(16px);
                                border-radius: 36px;
                                border: 2px solid rgba(255, 255, 255, 0.2);
                                box-shadow: 
                                    0 25px 50px -12px rgba(0, 0, 0, 0.25),
                                    0 0 0 1px rgba(255, 255, 255, 0.1) inset,
                                    0 0 40px rgba(79, 70, 229, 0.2) inset;
                                overflow: hidden;
                                transform: perspective(800px) rotateY(-15deg) rotateX(10deg);
                                transition: transform 0.5s cubic-bezier(0.34, 1.56, 0.64, 1);
                            }
                            
                            .ar-phone-mockup::before {
                                content: "";
                                position: absolute;
                                top: 0;
                                left: 0;
                                right: 0;
                                height: 30px;
                                background: rgba(0, 0, 0, 0.2);
                                border-radius: 36px 36px 0 0;
                                z-index: 2;
                            }
                            
                            .ar-phone-mockup::after {
                                content: "";
                                position: absolute;
                                top: 12px;
                                left: 50%;
                                transform: translateX(-50%);
                                width: 80px;
                                height: 8px;
                                background: rgba(0, 0, 0, 0.3);
                                border-radius: 4px;
                                z-index: 3;
                            }
                            
                            .ar-phone-mockup:hover {
                                transform: perspective(800px) rotateY(-5deg) rotateX(5deg) scale(1.05);
                                box-shadow: 
                                    0 30px 60px -15px rgba(0, 0, 0, 0.3),
                                    0 0 0 1px rgba(255, 255, 255, 0.15) inset,
                                    0 0 50px rgba(79, 70, 229, 0.3) inset;
                            }
                            
                            .ar-graphic-element {
                                position: relative;
                                height: 100%;
                                width: 100%;
                            }
                            
                            .ar-graphic-element img {
                                width: 100%;
                                height: 100%;
                                object-fit: cover;
                            }
                            
                            .ar-animation-overlay {
                                position: absolute;
                                top: 0;
                                left: 0;
                                width: 100%;
                                height: 100%;
                                z-index: 1;
                                overflow: hidden;
                            }
                            
                            .ar-animation-overlay::before {
                                content: "";
                                position: absolute;
                                top: -150%;
                                left: -150%;
                                width: 400%;
                                height: 400%;
                                background: linear-gradient(
                                    to bottom right,
                                    rgba(255, 255, 255, 0) 30%,
                                    rgba(255, 255, 255, 0.3) 50%,
                                    rgba(255, 255, 255, 0) 70%
                                );
                                animation: shine 4s linear infinite;
                            }
                            
                            .hero-stats {
                                display: flex;
                                align-items: center;
                                justify-content: space-around;
                                background: rgba(255, 255, 255, 0.07);
                                backdrop-filter: blur(20px);
                                border-radius: var(--border-radius-md);
                                padding: var(--spacing-6) var(--spacing-5);
                                margin-top: var(--spacing-10);
                                width: 100%;
                                z-index: 2;
                                border: 1px solid rgba(255, 255, 255, 0.1);
                                box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
                                animation: fadeInUp 1s ease-out 0.3s both;
                            }
                            
                            .stat-item {
                                text-align: center;
                                padding: 0 var(--spacing-5);
                                position: relative;
                            }
                            
                            .stat-value {
                                font-size: var(--font-size-3xl);
                                font-weight: 700;
                                margin-bottom: var(--spacing-2);
                                background: linear-gradient(to right, #ffffff, #e2e8f0);
                                -webkit-background-clip: text;
                                background-clip: text;
                                -webkit-text-fill-color: transparent;
                            }
                            
                            .stat-label {
                                font-size: var(--font-size-sm);
                                opacity: 0.8;
                                font-weight: 500;
                                white-space: nowrap;
                            }
                            
                            .stat-divider {
                                width: 1px;
                                height: 40px;
                                background: rgba(255, 255, 255, 0.2);
                            }
                            
                            /* Section title */
                            .section-title {
                                text-align: center;
                                margin-bottom: var(--spacing-16);
                                animation: fadeIn 0.8s ease-out;
                            }
                            
                            .section-title h2 {
                                font-size: var(--font-size-3xl);
                                font-weight: 700;
                                margin-bottom: var(--spacing-4);
                                color: var(--primary-dark);
                                position: relative;
                                display: inline-block;
                                letter-spacing: -0.015em;
                            }
                            
                            .section-title h2::after {
                                content: "";
                                position: absolute;
                                bottom: -10px;
                                left: 50%;
                                transform: translateX(-50%);
                                width: 100%;
                                height: 4px;
                                background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
                                border-radius: 2px;
                            }
                            
                            .section-title p {
                                font-size: var(--font-size-lg);
                                color: var(--text-light);
                                max-width: 600px;
                                margin: var(--spacing-6) auto 0;
                                line-height: 1.6;
                            }
                            
                            /* Steps container */
                            .steps-container {
                                grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
                                gap: 0 var(--spacing-6);
                                margin-bottom: 64px;
                            }
                            
                            .step-card {
                                position: relative;
                                background: white;
                                margin-bottom: var(--spacing-6);
                                border-radius: var(--border-radius-lg);
                                border: 1px solid var(--border-color);
                                padding: var(--spacing-8);
                                box-shadow: var(--shadow-sm);
                                transition: all 0.3s cubic-bezier(0.34, 1.56, 0.64, 1);
                                cursor: pointer;
                                z-index: 1;
                                animation: fadeInUp 0.6s cubic-bezier(0.34, 1.56, 0.64, 1);
                                animation-fill-mode: both;
                            }
                            
                            .step-card:nth-child(1) { animation-delay: 0.1s; }
                            .step-card:nth-child(2) { animation-delay: 0.2s; }
                            .step-card:nth-child(3) { animation-delay: 0.3s; }
                            .step-card:nth-child(4) { animation-delay: 0.4s; }
                            
                            .step-card::before {
                                content: "";
                                position: absolute;
                                top: 0;
                                left: 0;
                                right: 0;
                                height: 6px;
                                background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
                                opacity: 0;
                                transition: opacity var(--transition-medium);
                                border-radius: var(--border-radius-lg) var(--border-radius-lg) 0 0;
                            }
                            
                            .step-card:hover {
                                box-shadow: var(--shadow-lg);
                                transform: translateY(-8px);
                            }
                            
                            .step-card:hover::before {
                                opacity: 1;
                            }
                            
                            .step-card.active {
                                border-color: var(--primary-color);
                                box-shadow: 
                                    0 0 0 1px var(--primary-color),
                                    var(--shadow-lg);
                                background-color: var(--primary-light);
                                background-image: 
                                    radial-gradient(circle at 100% 100%, transparent 0%, rgba(79, 70, 229, 0.03) 100%);
                            }
                            
                            .step-card.active::before {
                                opacity: 1;
                            }
                            
                            .step-number {
                                position: absolute;
                                top: -20px;
                                left: var(--spacing-8);
                                width: 40px;
                                height: 40px;
                                background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
                                color: white;
                                border-radius: 50%;
                                display: flex;
                                align-items: center;
                                justify-content: center;
                                font-weight: 700;
                                font-size: var(--font-size-md);
                                z-index: 1;
                                box-shadow: 0 4px 8px rgba(79, 70, 229, 0.3);
                            }
                            
                            .step-icon {
                                margin-bottom: var(--spacing-5);
                                width: 52px;
                                height: 52px;
                                background: var(--primary-light);
                                border-radius: var(--border-radius-md);
                                display: flex;
                                align-items: center;
                                justify-content: center;
                                transition: all var(--transition-medium);
                                position: relative;
                                overflow: hidden;
                            }
                            
                            .step-card:hover .step-icon {
                                transform: scale(1.1);
                                background: linear-gradient(135deg, var(--primary-light), #ddd6fe);
                                box-shadow: 0 6px 12px rgba(79, 70, 229, 0.15);
                            }
                            
                            .step-content h3 {
                                font-size: var(--font-size-xl);
                                font-weight: 600;
                                margin-bottom: var(--spacing-3);
                                color: var(--primary-dark);
                                transition: color var(--transition-medium);
                            }
                            
                            .step-card:hover .step-content h3 {
                                color: var(--primary-color);
                            }
                            
                            .step-content p {
                                font-size: var(--font-size-md);
                                color: var(--text-light);
                                margin-bottom: var(--spacing-5);
                                line-height: 1.6;
                            }
                            
                            .step-instructions {
                                margin-bottom: var(--spacing-5);
                                padding: var(--spacing-4);
                                background: var(--background-light);
                                border-radius: var(--border-radius-md);
                                border-left: 3px solid var(--primary-color);
                                font-size: var(--font-size-sm);
                            }
                            
                            .step-instructions ul {
                                list-style-position: inside;
                                padding-left: 16px;
                            }
                            
                            .step-instructions li {
                                margin-bottom: 8px;
                            }
                            
                            .step-action {
                                margin-top: var(--spacing-6);
                            }
                            
                            .ardisplay-button.primary {
                                background-color: var(--primary-color);
                                color: white;
                                padding: 12px 20px;
                                border-radius: 8px;
                                font-weight: 600;
                                border: none;
                                cursor: pointer;
                                transition: all 0.2s;
                                box-shadow: var(--shadow-sm);
                                width: 100%;
                                font-size: 16px;
                            }
                            
                            .ardisplay-button.primary:hover {
                                background-color: var(--primary-dark);
                                box-shadow: var(--shadow-md);
                                transform: translateY(-2px);
                            }
                            
                            /* Features section */
                            .features-section {
                                margin-bottom: 64px;
                                padding: var(--spacing-10) 0;
                                background: linear-gradient(to bottom, rgba(237, 233, 254, 0.3), transparent);
                                border-radius: var(--border-radius-lg);
                            }
                            
                            .features-section h2 {
                                text-align: center;
                                font-size: var(--font-size-3xl);
                                font-weight: 700;
                                margin-bottom: var(--spacing-10);
                                color: var(--primary-dark);
                                position: relative;
                                display: inline-block;
                                left: 50%;
                                transform: translateX(-50%);
                            }
                            
                            .features-section h2::after {
                                content: "";
                                position: absolute;
                                bottom: -10px;
                                left: 50%;
                                transform: translateX(-50%);
                                width: 100%;
                                height: 4px;
                                background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
                                border-radius: 2px;
                            }
                            
                            .features-grid {
                                display: grid;
                                grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
                                gap: 24px;
                            }
                            
                            .feature-card {
                                background: white;
                                border-radius: var(--border-radius-lg);
                                border: 1px solid var(--border-color);
                                padding: var(--spacing-8) var(--spacing-6);
                                text-align: center;
                                box-shadow: var(--shadow-sm);
                                transition: all var(--transition-medium) cubic-bezier(0.34, 1.56, 0.64, 1);
                                position: relative;
                                overflow: hidden;
                                animation: fadeIn 0.8s ease-out;
                                animation-fill-mode: both;
                            }
                            
                            .feature-card:nth-child(1) { animation-delay: 0.1s; }
                            .feature-card:nth-child(2) { animation-delay: 0.2s; }
                            .feature-card:nth-child(3) { animation-delay: 0.3s; }
                            .feature-card:nth-child(4) { animation-delay: 0.4s; }
                            
                            .feature-card::before {
                                content: "";
                                position: absolute;
                                top: 0;
                                left: 0;
                                right: 0;
                                bottom: 0;
                                background: linear-gradient(135deg, var(--primary-light), rgba(237, 233, 254, 0.2));
                                opacity: 0;
                                transition: opacity var(--transition-medium);
                                z-index: 0;
                            }
                            
                            .feature-card:hover {
                                box-shadow: var(--shadow-lg);
                                transform: translateY(-8px);
                                border-color: rgba(79, 70, 229, 0.2);
                            }
                            
                            .feature-card:hover::before {
                                opacity: 1;
                            }
                            
                            .feature-icon {
                                width: 64px;
                                height: 64px;
                                margin: 0 auto var(--spacing-5);
                                background: var(--primary-light);
                                border-radius: 50%;
                                display: flex;
                                align-items: center;
                                justify-content: center;
                                transition: all var(--transition-medium);
                                position: relative;
                                z-index: 1;
                            }
                            
                            .feature-card:hover .feature-icon {
                                transform: scale(1.1) rotate(5deg);
                                background: linear-gradient(135deg, var(--primary-light), #ddd6fe);
                                box-shadow: 0 8px 16px rgba(79, 70, 229, 0.15);
                            }
                            
                            .feature-icon span {
                                font-size: 32px;
                                position: relative;
                                z-index: 1;
                            }
                            
                            .feature-card h3 {
                                font-size: var(--font-size-lg);
                                font-weight: 600;
                                margin-bottom: var(--spacing-3);
                                color: var(--primary-dark);
                                position: relative;
                                z-index: 1;
                            }
                            
                            .feature-card p {
                                font-size: var(--font-size-md);
                                color: var (--text-light);
                                line-height: 1.6;
                                position: relative;
                                z-index: 1;
                            }
                            
                            /* Testimonials section */
                            .testimonials-section {
                                margin-bottom: 64px;
                            }
                            
                            .testimonials-section h2 {
                                text-align: center;
                                font-size: var(--font-size-3xl);
                                font-weight: 700;
                                margin-bottom: var(--spacing-10);
                                color: var(--primary-dark);
                                position: relative;
                                display: inline-block;
                                left: 50%;
                                transform: translateX(-50%);
                            }
                            
                            .testimonials-section h2::after {
                                content: "";
                                position: absolute;
                                bottom: -10px;
                                left: 50%;
                                transform: translateX(-50%);
                                width: 100%;
                                height: 4px;
                                background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
                                border-radius: 2px;
                            }
                            
                            .testimonials-carousel {
                                max-width: 800px;
                                margin: 0 auto;
                                position: relative;
                                padding: var(--spacing-4);
                            }
                            
                            .testimonials-carousel::before {
                                content: """;
                                position: absolute;
                                top: 0;
                                left: 0;
                                font-size: 150px;
                                color: var(--primary-light);
                                line-height: 1;
                                font-family: serif;
                                opacity: 0.5;
                            }
                            
                            .testimonial-card {
                                background: white;
                                border-radius: var(--border-radius-lg);
                                border: 1px solid var(--border-color);
                                padding: var(--spacing-8);
                                box-shadow: var(--shadow-lg);
                                position: relative;
                                z-index: 1;
                                transition: transform var(--transition-medium);
                                animation: fadeIn 0.8s ease-out;
                            }
                            
                            .testimonial-card:hover {
                                transform: translateY(-5px);
                            }
                            
                            .testimonial-content {
                                margin-bottom: var(--spacing-6);
                                position: relative;
                                z-index: 1;
                            }
                            
                            .testimonial-content p {
                                font-size: var(--font-size-lg);
                                line-height: 1.6;
                                color: var(--text-color);
                                font-style: italic;
                                position: relative;
                            }
                            
                            .testimonial-author {
                                display: flex;
                                align-items: center;
                                border-top: 1px solid var(--border-color);
                                padding-top: var(--spacing-4);
                            }
                            
                            .author-avatar {
                                width: 50px;
                                height: 50px;
                                border-radius: 50%;
                                background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
                                color: white;
                                display: flex;
                                align-items: center;
                                justify-content: center;
                                font-weight: 600;
                                margin-right: var(--spacing-4);
                                box-shadow: 0 4px 8px rgba(79, 70, 229, 0.25);
                            }
                            
                            .author-info h4 {
                                font-size: var(--font-size-md);
                                font-weight: 600;
                                margin: 0 0 4px 0;
                                color: var(--primary-dark);
                            }
                            
                            .author-info p {
                                font-size: var(--font-size-sm);
                                color: var(--text-light);
                                margin: 0;
                            }
                            
                            /* CTA section */
                            .cta-section {
                                margin-bottom: 64px;
                            }
                            
                            .cta-card {
                                background: linear-gradient(to right, #f8fafc, #ede9fe);
                                border-radius: var(--border-radius-xl);
                                color: var(--text-color);
                                overflow: hidden;
                                position: relative;
                            }
                            
                            .cta-card::before {
                                content: "";
                                position: absolute;
                                top: 0;
                                left: 0;
                                right: 0;
                                bottom: 0;
                                background-image: url("data:image/svg+xml,%3Csvg width='100' height='100' viewBox='0 0 100 100' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M11 18c3.866 0 7-3.134 7-7s-3.134-7-7-7-7 3.134-7 7 3.134 7 7 7zm48 25c3.866 0 7-3.134 7-7s-3.134-7-7-7-7 3.134-7 7 3.134 7 7 7zm-43-7c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zm63 31c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zM34 90c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zm56-76c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zM12 86c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm28-65c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm23-11c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm-6 60c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm29 22c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zM32 63c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm57-13c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm-9-21c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM60 91c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM35 41c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM12 60c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2z' fill='%234f46e5' fill-opacity='0.05' fill-rule='evenodd'/%3E%3C/svg%3E");
                                opacity: 0.4;
                            }
                            
                            .cta-content {
                                padding: var(--spacing-10);
                                text-align: center;
                                position: relative;
                                z-index: 1;
                            }
                            
                            .cta-icon {
                                width: 80px;
                                height: 80px;
                                margin: 0 auto var(--spacing-6);
                                background: linear-gradient(135deg, var(--primary-light), #ddd6fe);
                                border-radius: 50%;
                                display: flex;
                                align-items: center;
                                justify-content: center;
                                box-shadow: 0 10px 20px rgba(79, 70, 229, 0.15);
                                position: relative;
                                animation: pulse 3s infinite;
                            }
                            
                            .cta-icon span {
                                font-size: 40px;
                                color: var(--primary-color);
                            }
                            
                            .cta-content h2 {
                                font-size: var(--font-size-2xl);
                                font-weight: 700;
                                margin-bottom: var(--spacing-4);
                                color: var(--primary-dark);
                                line-height: 1.3;
                            }
                            
                            .cta-content p {
                                font-size: var(--font-size-lg);
                                color: var(--text-light);
                                max-width: 600px;
                                margin: 0 auto var(--spacing-8);
                                line-height: 1.6;
                            }
                            
                            .cta-buttons {
                                display: flex;
                                gap: var(--spacing-4);
                                justify-content: center;
                                flex-wrap: wrap;
                            }
                            
                            /* Footer section */
                            .footer-section {
                                padding-top: var(--spacing-10);
                                border-top: 1px solid var(--border-color);
                            }
                            
                            .footer-links {
                                display: flex;
                                flex-wrap: wrap;
                                justify-content: center;
                                gap: var(--spacing-6);
                                margin-bottom: var(--spacing-6);
                            }
                            
                            .footer-links a {
                                color: var(--text-light);
                                text-decoration: none;
                                transition: color var(--transition-fast);
                                position: relative;
                            }
                            
                            .footer-links a::after {
                                content: "";
                                position: absolute;
                                bottom: -4px;
                                left: 0;
                                width: 0;
                                height: 2px;
                                background: var(--primary-color);
                                transition: width var(--transition-medium);
                            }
                            
                            .footer-links a:hover::after {
                                width: 100%;
                            }
                            
                            .footer-links a:hover {
                                color: var(--primary-color);
                            }
                            
                            .footer-copyright {
                                text-align: center;
                                color: var(--text-light);
                                font-size: var(--font-size-sm);
                            }
                            
                            /* Utility classes */
                            .ardisplay-link {
                                text-decoration: none;
                                cursor: pointer;
                                all: unset;
                                display: block;
                                width: 100%;
                            }
                            
                            /* Animation */
                            @keyframes fadeIn {
                                from { opacity: 0; }
                                to { opacity: 1; }
                            }
                            
                            @keyframes fadeInUp {
                                from {
                                    opacity: 0;
                                    transform: translateY(20px);
                                }
                                to {
                                    opacity: 1;
                                    transform: translateY(0);
                                }
                            }
                            
                            @keyframes pulse {
                                0% {
                                    transform: scale(1);
                                    box-shadow: 0 0 0 0 rgba(79, 70, 229, 0.4);
                                }
                                70% {
                                    transform: scale(1.05);
                                    box-shadow: 0 0 0 10px rgba(79, 70, 229, 0);
                                }
                                100% {
                                    transform: scale(1);
                                    box-shadow: 0 0 0 0 rgba(79, 70, 229, 0);
                                }
                            }
                            
                            @keyframes float {
                                0% { background-position: 0% 0%; }
                                100% { background-position: 100% 100%; }
                            }
                            
                            @keyframes floatingDevice {
                                0% { transform: translateY(0px); }
                                50% { transform: translateY(-15px); }
                                100% { transform: translateY(0px); }
                            }
                            
                            @keyframes shine {
                                0% { transform: translateX(-100%) rotate(45deg); }
                                100% { transform: translateX(100%) rotate(45deg); }
                            }
                            
                            /* Responsive styles */
                            @media (max-width: 1024px) {
                                .hero-section {
                                    padding: var(--spacing-10) var(--spacing-8);
                                }
                                
                                .hero-section h1 {
                                    font-size: var(--font-size-4xl);
                                }
                            }
                            
                            @media (max-width: 768px) {
                                .hero-section {
                                    padding: var(--spacing-8) var(--spacing-5);
                                    flex-direction: column;
                                }
                                
                                .hero-content,
                                .hero-graphic {
                                    width: 100%;
                                    text-align: center;
                                }
                                
                                .hero-content {
                                    margin-bottom: var(--spacing-10);
                                }
                                
                                .hero-section h1 {
                                    font-size: var(--font-size-3xl);
                                }
                                
                                .hero-buttons {
                                    justify-content: center;
                                }
                                
                                .ar-phone-mockup {
                                    transform: perspective(800px) rotateY(0deg) rotateX(10deg);
                                    width: 240px;
                                    height: 480px;
                                }
                                
                                .hero-stats {
                                    flex-direction: column;
                                    gap: var(--spacing-5);
                                }
                                
                                .stat-divider {
                                    width: 80%;
                                    height: 1px;
                                    margin: var(--spacing-2) 0;
                                }
                                
                                .cta-content {
                                    padding: var(--spacing-6);
                                }
                                
                                .cta-content h2 {
                                    font-size: var(--font-size-xl);
                                }
                            }
                            
                            @media (max-width: 480px) {
                                .hero-section h1 {
                                    font-size: var(--font-size-2xl);
                                }
                                
                                .hero-section p {
                                    font-size: var(--font-size-md);
                                }
                                
                                .section-title h2, 
                                .features-section h2, 
                                .testimonials-section h2 {
                                    font-size: var(--font-size-2xl);
                                }
                                
                                .ar-phone-mockup {
                                    width: 200px;
                                    height: 400px;
                                }
                                
                                .feature-card,
                                .step-card {
                                    padding: var(--spacing-5);
                                }
                                
                                .testimonial-content p {
                                    font-size: var(--font-size-md);
                                }
                            }
                        </style>
                    </head>
                    <body>
                        <div class="ar-app-container">
                            <div class="hero-section">
                                <div class="hero-content">
                                    <h1>Transform Your Store with Augmented Reality</h1>
                                    <p>
                                        Elevate your customer experience with immersive 3D product visualization
                                    </p>
                                    <div class="hero-buttons">
                                        <a href="#get-started" class="ardisplay-link">
                                            <button class="ar-action-button primary">
                                                Get Started
                                            </button>
                                        </a>
                                    </div>
                                </div>
                                <div class="hero-graphic">
                                    <div class="ar-phone-mockup">
                                        <div class="ar-graphic-element">
                                            <img src="<?php echo AR_DISPLAY_PLUGIN_URL; ?>public/cbimage.png" alt="ARDisplay Shop" />
                                        </div>
                                        <div class="ar-animation-overlay"></div>
                                    </div>
                                </div>
                                <div class="hero-stats">
                                    <div class="stat-item">
                                        <span class="stat-value">37%</span>
                                        <span class="stat-label">Higher Conversion</span>
                                    </div>
                                    <div class="stat-divider"></div>
                                    <div class="stat-item">
                                        <span class="stat-value">42%</span>
                                        <span class="stat-label">Lower Returns</span>
                                    </div>
                                    <div class="stat-divider"></div>
                                    <div class="stat-item">
                                        <span class="stat-value">5★</span>
                                        <span class="stat-label">Customer Satisfaction</span>
                                    </div>
                                </div>
                            </div>

                            <div class="section-title" id="get-started">
                                <h2>Your Setup Journey</h2>
                                <p>
                                    Complete these 4 steps to enable AR experiences for your products
                                </p>
                            </div>

                            <div class="steps-container">
                                <div class="step-card active" data-step="1">
                                    <div class="step-number">1</div>
                                    <div class="step-content">
                                        <div class="step-icon">
                                            <span class="dashicons dashicons-key">🔑</span>
                                        </div>
                                        <h3>Get Your API Token</h3>
                                        <p>
                                            First, obtain an API token from ARDisplay to connect your
                                            WordPress store with our 3D visualization platform.
                                        </p>
                                        <div class="step-instructions">
                                            <ul>
                                                <li>
                                                    Visit <a href="https://ardisplay.io" target="_blank">ardisplay.io</a> and create an account
                                                </li>
                                                <li>Navigate to the Integration API</li>
                                                <li>Generate your unique API token</li>
                                            </ul>
                                        </div>
                                        <div class="step-action">
                                            <a href="https://ardisplay.io" target="_blank" class="ardisplay-link">
                                                <button class="ardisplay-button primary">Get API Token</button>
                                            </a>
                                        </div>
                                    </div>
                                </div>

                                <div class="step-card" data-step="2">
                                    <div class="step-number">2</div>
                                    <div class="step-content">
                                        <div class="step-icon">
                                            <span class="dashicons dashicons-admin-network">🔌</span>
                                        </div>
                                        <h3>Configure API Key</h3>
                                        <p>
                                            Connect your WordPress store with ARDisplay by securely
                                            configuring your API token in the app settings.
                                        </p>
                                        <div class="step-instructions">
                                            <ul>
                                                <li>Paste your API token from ARDisplay</li>
                                                <li>Click Save to establish connection</li>
                                                <li>Verify successful integration</li>
                                            </ul>
                                        </div>
                                        <div class="step-action">
                                            <a href="javascript:void(0)" class="ardisplay-link" onclick="navigateToPage('api-settings')">
                                                <button class="ardisplay-button primary">Configure API Key</button>
                                            </a>
                                        </div>
                                    </div>
                                </div>

                                <div class="step-card" data-step="3">
                                    <div class="step-number">3</div>
                                    <div class="step-content">
                                        <div class="step-icon">
                                            <span class="dashicons dashicons-products">📦</span>
                                        </div>
                                        <h3>Set Up Your Products</h3>
                                        <p>
                                            Select which products you want to enhance with AR experiences
                                            and upload your 3D models.
                                        </p>
                                        <div class="step-instructions">
                                            <ul>
                                                <li>Browse and select products to enable AR</li>
                                                <li>Upload 3D models for selected products</li>
                                                <li>Preview AR experience before publishing</li>
                                            </ul>
                                        </div>
                                        <div class="step-action">
                                            <a href="javascript:void(0)" class="ardisplay-link" onclick="navigateToPage('products')">
                                                <button class="ardisplay-button primary">Configure Products</button>
                                            </a>
                                        </div>
                                    </div>
                                </div>

                                <div class="step-card" data-step="4">
                                    <div class="step-number">4</div>
                                    <div class="step-content">
                                        <div class="step-icon">
                                            <span class="dashicons dashicons-admin-appearance">🎨</span>
                                        </div>
                                        <h3>Integrate with Your Theme</h3>
                                        <p>
                                            Add the AR viewer to your product pages with a customizable AR
                                            display button that matches your store's aesthetic.
                                        </p>
                                        <div class="step-instructions">
                                            <ul>
                                                <li>Open the theme editor integration</li>
                                                <li>Customize AR button appearance</li>
                                                <li>Position AR viewer on product pages</li>
                                                <li>Save changes and publish</li>
                                            </ul>
                                        </div>
                                        <div class="step-action">
                                            <a href="javascript:void(0)" class="ardisplay-link" onclick="navigateToPage('integration')">
                                                <button class="ardisplay-button primary">Configure Theme</button>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="features-section">
                                <h2>AR Display Features</h2>
                                <div class="features-grid">
                                    <div class="feature-card">
                                        <div class="feature-icon">
                                            <span class="dashicons dashicons-visibility">👁️</span>
                                        </div>
                                        <h3>360° Product Viewing</h3>
                                        <p>Allow customers to rotate and view products from all angles</p>
                                    </div>
                                    <div class="feature-card">
                                        <div class="feature-icon">
                                            <span class="dashicons dashicons-info">🏠</span>
                                        </div>
                                        <h3>Real-World Placement</h3>
                                        <p>Let customers place products in their actual environment</p>
                                    </div>
                                    <div class="feature-card">
                                        <div class="feature-icon">
                                            <span class="dashicons dashicons-products">🎨</span>
                                        </div>
                                        <h3>Product Customization</h3>
                                        <p>Visualize different colors and configurations in real-time</p>
                                    </div>
                                    <div class="feature-card">
                                        <div class="feature-icon">
                                            <span class="dashicons dashicons-chart-bar">📊</span>
                                        </div>
                                        <h3>Analytics & Insights</h3>
                                        <p>Track how customers interact with your 3D models</p>
                                    </div>
                                </div>
                            </div>

                            <div class="testimonials-section">
                                <h2>What Our Customers Say</h2>
                                <div class="testimonials-carousel">
                                    <div class="testimonial-card">
                                        <div class="testimonial-content">
                                            <p>
                                                "AR Display increased our conversion rate by 42% within the
                                                first month. Our customers love being able to see how
                                                furniture looks in their homes before purchasing."
                                            </p>
                                        </div>
                                        <div class="testimonial-author">
                                            <div class="author-avatar">JD</div>
                                            <div class="author-info">
                                                <h4>John Doe</h4>
                                                <p>Modern Furniture Co.</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="cta-section">
                                <div class="cta-card">
                                    <div class="cta-content">
                                        <div class="cta-icon">
                                            <span class="dashicons dashicons-visibility">👁️</span>
                                        </div>
                                        <h2>Ready to enhance your store with AR?</h2>
                                        <p>
                                            Start offering immersive shopping experiences to your customers
                                            today. Need help? Our support team is ready to assist you.
                                        </p>
                                        <div class="cta-buttons">
                                            <a href="https://ardisplay.io/contact-us" target="_blank" class="ardisplay-link">
                                                <button class="ardisplay-button primary">Contact Support</button>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="footer-section">
                                <div class="footer-links">
                                    <a href="https://www.ardisplay.io/about-us" class="ardisplay-link" target="_blank">About</a>
                                    <a href="https://www.ardisplay.io/pricing" class="ardisplay-link" target="_blank">Pricing</a>
                                    <a href="https://www.ardisplay.io/how-it-works" class="ardisplay-link" target="_blank">How it Works</a>
                                    <a href="https://www.ardisplay.io/contact-us" class="ardisplay-link" target="_blank">Contact Us</a>
                                </div>
                                <div class="footer-copyright">
                                    <p>© 2025 AR Display. All rights reserved.</p>
                                </div>
                            </div>
                        </div>

                        <script type="text/javascript">
                            // Function to handle navigation between pages
                            function navigateToPage(page) {
                                var parentWindow = window.parent;
                                switch(page) {
                                    case 'api-settings':
                                        parentWindow.location.href = '<?php echo $api_settings_url; ?>';
                                        break;
                                    case 'products':
                                        parentWindow.location.href = '<?php echo $products_url; ?>';
                                        break;
                                    case 'integration':
                                        parentWindow.location.href = '<?php echo $integration_url; ?>';
                                        break;
                                    default:
                                        console.error('Unknown page: ' + page);
                                }
                            }
                            
                            document.addEventListener('DOMContentLoaded', function() {
                                const stepCards = document.querySelectorAll('.step-card');
                                stepCards.forEach(card => {
                                    card.addEventListener('click', function() {
                                        stepCards.forEach(c => c.classList.remove('active'));
                                        this.classList.add('active');
                                    });
                                });
                            });
                        <\/script>
                    </body>
                    </html>
                `;

                // Write the content to the iframe
                if (iframe && iframe.contentWindow) {
                    iframe.contentWindow.document.open();
                    iframe.contentWindow.document.write(iframeContent);
                    iframe.contentWindow.document.close();
                } else {
                    console.error('Iframe or contentWindow not found');
                }
            } catch (error) {
                console.error('Error initializing iframe content:', error);
            }
        })();
        </script>
    </div>
    <?php
}

