<?php
/**
 * AR Display Modals Template
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
?>
<!-- Upload Modal -->
<div id="upload3dModal" class="modal" style="display: none;">
    <div class="modal-content">
        <span class="close">&times;</span>
        <h2>Upload 3D Model</h2>
        <!-- Step 1: Upload -->
        <div id="step1" class="modal-step">
            <div id="modelDropzone">
                <div class="dz-message" data-dz-message>
                    <span>Drag & drop a file here, or click to select<br>
                    <small>Supports images (.png, .jpg, .jpeg) and 3D models (.glb)</small></span>
                </div>
            </div>
            <table class="form-table">
                <tr>
                    <th><label for="modelPosition">Position</label></th>
                    <td>
                        <select id="modelPosition" class="regular-text">
                            <option value="wall">Wall</option>
                            <option value="floor">Floor</option>
                        </select>
                    </td>
                </tr>
            </table>
            <div class="modal-actions">
                <button type="button" class="button button-secondary" id="closeModelBtn">Close</button>
                <button type="button" class="button button-primary" id="nextModelBtn">Next</button>
            </div>
        </div>
        <!-- Step 2: Preview / Crop Image -->
        <div id="step2" class="modal-step" style="display: none;">
            <div id="imagePreview" class="image-preview"></div>
            <button type="button" class="button button-secondary" id="cropImageBtn">Crop Image</button>
            <div class="modal-actions">
                <button type="button" class="button button-secondary" id="backModelBtn">Back</button>
                <button type="button" class="button button-primary" id="nextStep2Btn">Next</button>
            </div>
        </div>
        <!-- Step 3: Crop -->
        <div id="step3" class="modal-step" style="display: none;">
            <div id="crop-container" class="crop-container">
                <img src="" alt="To Crop" />
            </div>
            <div class="modal-actions">
                <button type="button" class="button button-secondary" id="backCropBtn">Back</button>
                <button type="button" class="button button-primary" id="applyCropBtn">Apply Crop</button>
            </div>
        </div>
        <!-- Step 4: Model Viewer Step -->
        <div id="step4" class="modal-step" style="display: none;">
            <div id="frameButtonsContainer" style="text-align: center; margin-bottom: 15px;"></div>
            <div id="modelViewer" class="model-viewer-container"></div>
            <div class="modal-actions" id="modelActions">
                <button type="button" class="button button-secondary" id="closeModelBtnStep4">Back</button>
                <button type="button" class="button button-primary" id="nextFinalBtn">Next</button>
            </div>
        </div>
        <!-- Step 5: Size Adjustments -->
        <div id="step5" class="modal-step" style="display: none;">
            <div id="modelViewerStep5" class="model-viewer-container"></div>
            <div id="sizeRowsContainer" class="size-container">
                <div style="display: flex; justify-content: space-between; align-items: center;">
                    <h3>Model Dimensions</h3>
                    <button type="button" id="addSizeRow" class="button button-secondary">Add New Size</button>
                </div>

                <table class="size-table">
                    <thead>
                        <tr>
                            <th>Label</th>
                            <th>Width</th>
                            <th>Height</th>
                            <th>Depth</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
            <div class="modal-actions">
                <button type="button" id="backStep5Btn" class="button button-secondary">Back</button>
                <button type="button" id="finalizeBtn" class="button button-primary">Finalize</button>
            </div>
        </div>
        <!-- Step 6: Uploading Files -->
        <div id="step6" class="modal-step" style="display: none;">
            <h2>Uploading Files</h2>
            <div class="upload-progress">
                <div id="uploadProgressText">0 B / 0 B</div>
                <div id="uploadProgressBarContainer">
                    <div id="uploadProgressBar"></div>
                </div>
            </div>
            <div class="modal-actions">
                <button type="button" class="button button-secondary" id="cancelUploadBtn">Cancel</button>
            </div>
        </div>
    </div>
</div>

<!-- Preview Modal -->
<div id="previewModal" class="modal" style="display: none;">
    <div class="modal-content">
        <span class="close">&times;</span>
        <h2>Model Preview</h2>
        <div id="previewSizeButtons" class="size-buttons"></div>
        <div id="previewModelViewer" class="model-viewer-container"></div>
        <div class="modal-actions">
            <button type="button" class="button button-secondary" id="closePreviewBtn">Close</button>
        </div>
    </div>
</div>

<!-- Import model-viewer as an ES Module -->
<script type="module" src="https://unpkg.com/@google/model-viewer/dist/model-viewer.min.js"></script>
