<?php if (!defined('ABSPATH')) exit; ?>
<script type="module">
    window.showStep = function(stepNumber) {
        const step1 = document.getElementById('step1');
        const step2 = document.getElementById('step2');
        const step3 = document.getElementById('step3');
        const step4 = document.getElementById('step4');
        const step5 = document.getElementById('step5');
        const step6 = document.getElementById('step6');

        step1.style.display = stepNumber === 1 ? 'block' : 'none';
        step2.style.display = stepNumber === 2 ? 'block' : 'none';
        step3.style.display = stepNumber === 3 ? 'block' : 'none';
        step4.style.display = stepNumber === 4 ? 'block' : 'none';
        step5.style.display = stepNumber === 5 ? 'block' : 'none';
        step6.style.display = stepNumber === 6 ? 'block' : 'none';
        
        if (stepNumber === 4) {
            var frameButtons = document.getElementById("frameButtonsContainer");
            if (window.currentFileType === "glb") {
                frameButtons.style.display = "none";
                frameButtons.innerHTML = "";
            } else {
                frameButtons.style.display = "flex";
            }
        }
    };

    window.closeModal = function() {
        const modal = document.getElementById('upload3dModal');
        modal.style.display = "none";
        window.originalImage = null;
        window.currentFileType = "";
        window.currentFrameIndex = 0;
        const modelViewer = document.querySelector("#modelViewer model-viewer");
        if (modelViewer) { modelViewer.src = ""; }
        const modelViewerStep5 = document.querySelector("#modelViewerStep5 model-viewer");
        if (modelViewerStep5) { modelViewerStep5.src = ""; }
        window.dropzone.removeAllFiles();
        var frameButtons = document.getElementById("frameButtonsContainer");
        if (frameButtons) { frameButtons.innerHTML = ""; }
        const container = document.querySelector("#sizeRowsContainer tbody");
        if (container) { container.innerHTML = ''; }
        window.showStep(1);
        if (window.generatedModelUrl) { URL.revokeObjectURL(window.generatedModelUrl); window.generatedModelUrl = ""; }
        if (window.cropInstance) { window.cropInstance.destroy(); window.cropInstance = null; }
        if (window.uploadXhr) { window.uploadXhr = null; }
        window.finalGLBBlob = null;
        window.finalUSDZBlob = null;
        window.selectedFrameStyle = null;  // Reset selected frame style
        window.currentFrameIndex = 0;      // Reset frame index
        delete modal.dataset.editingRow;
    };

    window.initializeCrop = function() {
        const cropContainer = document.getElementById('crop-container');
        const img = cropContainer.querySelector('img');
        
        // Add styling to container and image
        cropContainer.style.width = 'fit-content';
        cropContainer.style.margin = '0 auto';
        img.style.maxHeight = '500px';
        img.style.width = 'auto';
        
        if (window.cropInstance) { 
            window.cropInstance.destroy(); 
        }
        
        window.cropInstance = new SimpleCrop(cropContainer, {
            minWidth: 100,
            minHeight: 100,
            maxWidth: img.naturalWidth,
            maxHeight: img.naturalHeight,
            startX: 0,
            startY: 0,
            onChange: function(crop) { console.log('Crop changed:', crop); },
            onComplete: function(crop) { console.log('Crop complete:', crop); }
        });
        
        // Center the initial crop selection
        if (!SimpleCrop.lastCropState) {
            const cropWidth = Math.min(img.naturalWidth, 300);
            const cropHeight = Math.min(img.naturalHeight, 300);
            const startX = (img.naturalWidth - cropWidth) / 2;
            const startY = (img.naturalHeight - cropHeight) / 2;
            
            window.cropInstance.setSelectionStyle(
                startX,
                startY,
                cropWidth,
                cropHeight
            );
            window.cropInstance.updateCrop();
        } else {
            window.cropInstance.setSelectionStyle(
                SimpleCrop.lastCropState.left,
                SimpleCrop.lastCropState.top,
                SimpleCrop.lastCropState.width,
                SimpleCrop.lastCropState.height
            );
            window.cropInstance.updateCrop();
        }
    };
</script>
