<?php if (!defined('ABSPATH')) exit; ?>
<script type="module">
    window.updateExistingRow = function(newModel) {
        const modal = document.getElementById('upload3dModal');
        const rowIndex = parseInt(modal.dataset.editingRow);
        const tableBody = document.querySelector('#uploadedModelsTable tbody');
        const existingRow = tableBody.rows[rowIndex - 1];

        if (existingRow) {
            let sizesText = "";
            if (newModel.sizes && newModel.sizes.length > 0) {
                sizesText = newModel.sizes.map(size => 
                    `${size.label || 'Size'}: ${parseFloat(size.width).toFixed(1)}cm × ${parseFloat(size.height).toFixed(1)}cm × ${parseFloat(size.depth).toFixed(1)}cm`
                ).join("<br>");
            }

            existingRow.cells[2].innerHTML = sizesText || 'No sizes specified';
            existingRow.querySelector('.previewBtn').dataset.url = newModel.url;
            existingRow.querySelector('.editModel').dataset.url = newModel.url;
            existingRow.dataset.sizes = JSON.stringify(newModel.sizes);
            existingRow.dataset.usdzUrl = newModel.usdzUrl || '';
            existingRow.dataset.posterFileUrl = newModel.posterFileUrl || newModel.posterFileUrl;
        }
    };

    window.addModelToTable = function(newModel) {
        // Safety check for table body
        let tableBody = document.querySelector('#uploadedModelsTable tbody');
        if (!tableBody) {
            console.error('Table body not found');
            return;
        }

        window.modelCounter++;

        let sizesText = "";
        if (newModel.sizes && newModel.sizes.length > 0) {
            sizesText = newModel.sizes.map(size => 
                `${size.label || 'Size'}: ${parseFloat(size.width).toFixed(1)}cm × ${parseFloat(size.height).toFixed(1)}cm × ${parseFloat(size.depth).toFixed(1)}cm`
            ).join("<br>");
        }

        const row = document.createElement('tr');
        row.dataset.model = JSON.stringify(newModel);
        row.innerHTML = `
            <td>${window.modelCounter}</td>
            <td>${newModel.fileType === 'glb' ? 'Model' : 'Image'}</td>
            <td>${sizesText || 'No sizes specified'}</td>
            <td><button type="button" class="button previewBtn" data-url="${newModel.url}">Preview Model</button></td>
            <td>
                <a href="#" class="button-link editModel" data-url="${newModel.url}">Edit</a> |
                <a href="#" class="button-link deleteModel" data-ids="${[newModel.androidId, newModel.iosId , newModel.posterFileId]}">Delete</a>
            </td>
        `;
        
        // Store the USDZ and poster URLs in the row's dataset
        if (newModel.usdzUrl) row.dataset.usdzUrl = newModel.usdzUrl;
        if (newModel.posterFileUrl) row.dataset.posterFileUrl = newModel.posterFileUrl;

        // Remove "No items" message if it exists
        const noItems = tableBody.querySelector('.no-items');
        if (noItems) {
            noItems.remove();
        }
        
        // Add the new row
        tableBody.appendChild(row);

        // Store sizes in the row's dataset for later use
        if (newModel.sizes && newModel.sizes.length > 0) {
            row.dataset.sizes = JSON.stringify(newModel.sizes);
        }

        // Add click handlers
        row.querySelector('.editModel').addEventListener('click', function(e) {
            e.preventDefault();
            const url = this.dataset.url;
            const row = this.closest('tr');
            const sizes = row.dataset.sizes ? JSON.parse(row.dataset.sizes) : [];
            
            // Show the modal
            const modal = document.getElementById('upload3dModal');
            modal.style.display = "flex";
            
            // Set the URL as current file and create blob
            fetch(url)
                .then(response => response.blob())
                .then(blob => {
                    // Create a File object from the Blob
                    const file = new File([blob], "model.glb", { type: "model/gltf-binary" });
                    
                    // Clear existing files and add the new one
                    window.dropzone.removeAllFiles();
                    window.dropzone.addFile(file);
                    
                    // Set the current type and uploaded file
                    window.currentFileType = "glb";
                    window.uploadedFile = file;
                    window.finalGLBBlob = blob; // Store the blob as finalGLBBlob
                    window.generatedModelUrl = URL.createObjectURL(blob);
                    
                    // Store the existing sizes for later use
                    window.uploadedModelSizes = sizes;
                    
                    // Store the row reference for updating later
                    modal.dataset.editingRow = row.rowIndex;

                    // Create model viewer in step 5 directly
                    const mvStep5 = document.getElementById("modelViewerStep5");
                    mvStep5.innerHTML = '';
                    const modelViewer = document.createElement('model-viewer');
                    modelViewer.setAttribute("src", window.generatedModelUrl);
                    modelViewer.setAttribute("ar", "");
                    modelViewer.setAttribute("autoplay", "");
                    modelViewer.setAttribute("camera-controls", "");
                    modelViewer.style.width = "100%";
                    modelViewer.style.height = "400px";
                    mvStep5.appendChild(modelViewer);
                    
                    // Wait for model to load then add size rows
                    modelViewer.addEventListener('load', () => {
                        const container = document.querySelector("#sizeRowsContainer tbody");
                        container.innerHTML = '';
                        
                        if (sizes && sizes.length > 0) {
                            sizes.forEach(size => {
                                window.addSizeRow({
                                    width: size.width,
                                    height: size.height,
                                    depth: size.depth,
                                    label: size.label
                                });
                            });
                        } else {
                            window.getModelDimensions(modelViewer)
                                .then(dimensions => window.addSizeRow(dimensions))
                                .catch(() => window.addSizeRow({ width: "100.00", height: "100.00", depth: "100.00" }));
                        }
                    });

                    // Go directly to step 5 (sizes)
                    window.showStep(5);
                })
                .catch(error => {
                    console.error('Error loading model:', error);
                    alert('Error loading model for editing');
                    window.closeModal();
                });
        });

        row.querySelector('.deleteModel').addEventListener('click', function(e) {
            e.preventDefault();

            const ids = this.dataset.ids.split(',').map(id => id.trim()).filter(id => id && id !== 'undefined' && id !== 'null');
            
            if (confirm("Are you sure you want to delete this model?")) {
                // Update document statuses if we have valid IDs
                if (ids && ids.length > 0) {
                    window.updateDocumentStatus(ids)
                        .then(response => {
                            console.error("Successfully updated document statuses:", response);
                        })
                        .catch(error => {
                            console.error("Error updating document statuses:", error);
                        });
                }
                
                row.remove();

                if (tableBody.querySelectorAll('tr').length === 0) {
                    const noItems = document.createElement('tr');
                    noItems.className = 'no-items';
                    noItems.innerHTML = '<td colspan="5">No models uploaded yet.</td>';
                    tableBody.appendChild(noItems);
                }
            }
        });

        // Add preview handler
        row.querySelector('.previewBtn').addEventListener('click', function(e) {
            e.preventDefault();
            const url = this.dataset.url;
            window.showPreviewModal(url);
        });
    };
</script>
