<?php if (!defined('ABSPATH')) exit; ?>
<script type="module">
    // Global variables that need to be accessible from event handlers
    let originalImage = null;
    let cropInstance = null;
    let dropzone;

    // Add to window for access from other modules
    window.originalImage = originalImage;
    window.cropInstance = cropInstance;
    window.dropzone = dropzone;

    // Define frame styles
    window.FRAME_STYLES = [
        { name: "Modern Thin", frameWidth: 0.02, frameDepth: 0.02, frameColor: 0x000000 },
        { name: "Classic White", frameWidth: 0.04, frameDepth: 0.03, frameColor: 0xffffff },
        { name: "Elegant Gold", frameWidth: 0.05, frameDepth: 0.03, frameColor: 0xd4af37 },
        { name: "Rustic Wood", frameWidth: 0.06, frameDepth: 0.04, frameColor: 0x8b4513 }
    ];

    document.addEventListener('DOMContentLoaded', function() {
        var modal = document.getElementById('upload3dModal');
        var btn = document.getElementById('add-3d-model');
        var span = document.getElementsByClassName('close')[0];
        var closeBtn = document.getElementById('closeModelBtn');
        var nextBtn = document.getElementById('nextModelBtn');
        var step1 = document.getElementById('step1');
        var step2 = document.getElementById('step2');
        var step3 = document.getElementById('step3');
        var step4 = document.getElementById('step4');
        var step5 = document.getElementById('step5');
        var step6 = document.getElementById('step6');
        var backBtn = document.getElementById('backModelBtn');
        var nextStep2Btn = document.getElementById('nextStep2Btn');
        var imagePreview = document.getElementById('imagePreview');
        var cropBtn = document.getElementById('cropImageBtn');
        var cropImage = document.getElementById('cropImage');
        var backCropBtn = document.getElementById('backCropBtn');
        var applyCropBtn = document.getElementById('applyCropBtn');
        var nextFinalBtn = document.getElementById('nextFinalBtn');

        // Initialize Dropzone
        Dropzone.autoDiscover = false;
        dropzone = new Dropzone("#modelDropzone", {
            url: "#",
            autoProcessQueue: false,
            maxFiles: 1,
            acceptedFiles: '.glb,.png,.jpg,.jpeg',
            addRemoveLinks: true,
            dictRemoveFile: 'Remove file',
            createImageThumbnails: false,
            maxfilesexceeded: function(file) {
                this.removeAllFiles();
                this.addFile(file);
            },
            init: function() {
                this.element.classList.add('dropzone');
                
                // Clear existing files when adding new one
                this.on("addedfile", function() {
                    if (this.files.length > 1) {
                        this.removeFile(this.files[0]);
                    }
                });
            },
            accept: function(file, done) {
                if (file.type.startsWith('image/')) {
                    done();
                } else if (file.name.endsWith('.glb')) {
                    done();
                } else {
                    done("Invalid file type");
                }
            }
        });
        
        // Store dropzone in window for access from other modules
        window.dropzone = dropzone;

        btn.onclick = function() { modal.style.display = "flex"; window.showStep(1); }
        span.onclick = window.closeModal;
        closeBtn.onclick = window.closeModal;
        window.onclick = function(event) { if (event.target == modal) { window.closeModal(); } }

        nextBtn.onclick = function() {
            var files = dropzone.getAcceptedFiles();
            if (files.length > 0) {
                var file = files[0];
                // Reset the uploadedModelSizes when uploading a new file
                window.uploadedModelSizes = [];
                
                if (file.type.startsWith('image/')) {
                    window.currentFileType = "image";
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        window.originalImage = e.target.result;
                        imagePreview.innerHTML = '<img src="' + window.originalImage + '" />';
                        window.showStep(2);
                    };
                    reader.readAsDataURL(file);
                } else if (file.name.endsWith('.glb')) {
                    window.currentFileType = "glb";
                    window.uploadedFile = file;
                    window.finalGLBBlob = file;  // Store the file as blob
                    window.generatedModelUrl = URL.createObjectURL(file);
                    window.showStep(4);
                    window.setupModelViewer(window.generatedModelUrl, false);
                }
            } else {
                alert('Please upload a file');
            }
        };

        cropBtn.onclick = function() {
            window.showStep(3);
            var cropContainer = document.getElementById('crop-container');
            var img = cropContainer.querySelector('img');
            img.src = window.originalImage;
            
            if (img.complete) {
                window.initializeCrop();
            } else {
                img.onload = window.initializeCrop;
            }
        };

        applyCropBtn.onclick = function() {
            if (window.cropInstance) {
                var img = document.getElementById('crop-container').querySelector('img');
                var crop = window.cropInstance.crop;
                
                // Store the current crop state for later use
                SimpleCrop.lastCropState = {
                    left: window.cropInstance.selection.offsetLeft,
                    top: window.cropInstance.selection.offsetTop,
                    width: window.cropInstance.selection.offsetWidth,
                    height: window.cropInstance.selection.offsetHeight
                };
                
                var canvas = document.createElement('canvas');
                canvas.width = crop.width;
                canvas.height = crop.height;
                var ctx = canvas.getContext('2d');
                ctx.drawImage(img, crop.x, crop.y, crop.width, crop.height, 0, 0, crop.width, crop.height);
                imagePreview.innerHTML = '<img src="' + canvas.toDataURL('image/jpeg', 0.9) + '" />';
                window.showStep(2);
            }
        };

        backCropBtn.onclick = function() { if (window.cropInstance) { window.cropInstance = null; } window.showStep(2); };
        backBtn.onclick = function() { window.showStep(1); };

        nextStep2Btn.onclick = function() {
            var imgElement = imagePreview.querySelector("img");
            if (imgElement && imgElement.src) {
                const textureLoader = new THREE.TextureLoader();
                textureLoader.load(imgElement.src, function(texture) {
                    // Initialize selectedFrameStyle if not set
                    window.selectedFrameStyle = window.selectedFrameStyle || window.FRAME_STYLES[0];
                    window.createGLBModel(texture, window.selectedFrameStyle)
                        .then(function(glbOutput) {
                            window.finalGLBBlob = new Blob([glbOutput], { type: "model/gltf-binary" });
                            window.generatedModelUrl = URL.createObjectURL(window.finalGLBBlob);
                            window.showStep(4);
                            window.generateFrameButtons(texture, imgElement.src);
                            window.setupModelViewer(window.generatedModelUrl, true);
                        })
                        .catch(function(error) { alert("Error creating model: " + error); });
                });
            } else { alert("No image available."); }
        };

        if (document.getElementById("backModelViewerBtn")) {
            document.getElementById("backModelViewerBtn").onclick = function() { window.showStep(2); };
        }

        if (nextFinalBtn) {
            nextFinalBtn.onclick = async function() {
                console.log("Next Final Button clicked");
                var mv = document.getElementById("modelViewer");
                var mvStep5 = document.getElementById("modelViewerStep5");
                if (mv && mvStep5) {
                    mvStep5.innerHTML = mv.innerHTML;
                    const modelViewer = mvStep5.querySelector('model-viewer');
                    modelViewer.addEventListener('load', async () => {
                        try {
                            const container = document.querySelector("#sizeRowsContainer tbody");
                            container.innerHTML = '';
                            
                            // If we're in edit mode and have existing sizes, use those
                            if (window.uploadedModelSizes && window.uploadedModelSizes.length > 0) {
                                window.uploadedModelSizes.forEach(size => {
                                    window.addSizeRow({
                                        width: size.width,
                                        height: size.height,
                                        depth: size.depth,
                                        label: size.label
                                    });
                                });
                            } else {
                                // Otherwise, get default dimensions and add "Default Size" label
                                const defaultDimensions = await window.getModelDimensions(modelViewer);
                                window.addSizeRow({
                                    ...defaultDimensions,
                                    label: "Default Size"
                                });
                            }
                        } catch (error) {
                            window.addSizeRow({ 
                                width: "100.00", 
                                height: "100.00", 
                                depth: "100.00",
                                label: "Default Size"
                            });
                        }
                    });
                    window.showStep(5);
                } else {
                    console.error("Model viewer elements not found");
                }
            };
        }

        document.getElementById("closeModelBtnStep4").onclick = function() { window.closeModal(); };
        document.getElementById("backStep5Btn").onclick = function() {
            const modelViewer = document.querySelector("#modelViewer");
            modelViewer.innerHTML = ''; // Clear existing viewer
            
            const newViewer = document.createElement('model-viewer');
            newViewer.setAttribute("src", window.generatedModelUrl);
            newViewer.setAttribute("ar", "");
            newViewer.setAttribute("autoplay", "");
            newViewer.setAttribute("camera-controls", "");
            newViewer.style.width = "100%";
            newViewer.style.height = "400px";
            modelViewer.appendChild(newViewer);
            
            // Force the back button text to be "Back"
            const closeBtn = document.getElementById("closeModelBtnStep4");
            closeBtn.textContent = "Back";
            closeBtn.onclick = function() {
                window.showStep(1);
            };
            
            window.showStep(4);
        };
        
        document.getElementById("finalizeBtn").onclick = async function() {
            // Get the selected placement from the dropdown
            const placementSelect = document.getElementById('modelPosition');
            const placement = placementSelect ? placementSelect.value : 'floor';
            const alignment = placement === "floor" ? "horizontal" : "vertical";

            var rows = document.querySelectorAll("#sizeRowsContainer tbody .size-row");
            if (rows.length === 0) {
                alert("Please add at least one size");
                return;
            }

            var sizes = [];
            var hasEmptyFields = false;
            rows.forEach(function(row) {
                var label = row.querySelector(".dimLabel").value.trim();
                var width = row.querySelector(".dimWidth").value.trim();
                var height = row.querySelector(".dimHeight").value.trim();
                var depth = row.querySelector(".dimDepth").value.trim();
                
                if (!label || !width || !height || !depth) {
                    hasEmptyFields = true;
                    return;
                }
                sizes.push({ label, width, height, depth });
            });

            if (hasEmptyFields) {
                alert("Please fill in all size fields (label, width, height, and depth)");
                return;
            }

            // Save sizes for later use
            window.uploadedModelSizes = sizes;
            
            if (modal.dataset.editingRow) {
                // For editing, we already have the GLB blob
                if (!window.finalGLBBlob) {
                    alert("Error: Model file not found");
                    return;
                }
                
                try {
                    window.createUSDZModelFromGLB(window.uploadedFile, alignment)
                        .then(function(usdzFile) {
                            window.finalUSDZBlob = usdzFile;
                            window.goToStep6AndUpload();
                        })
                        .catch(function(e) { 
                            alert("Error generating USDZ model: 298" + e); 
                        });
                } catch(e) { 
                    alert("Error generating USDZ model: 300" + e); 
                }
            } else {
                // Original code for new models

                if (window.currentFileType === "image") {
                    try {
                        const textureLoader = new THREE.TextureLoader();
                        textureLoader.load(window.originalImage, function(texture) {
                            // Use selectedFrameStyle instead of default frame style
                            window.createUSDZModel(texture, window.selectedFrameStyle || window.FRAME_STYLES[0], alignment)
                            .then(function(usdzArrayBuffer) {
                                window.finalUSDZBlob = new Blob([usdzArrayBuffer], { type: "model/usdz" });
                                const iosUrl = URL.createObjectURL(window.finalUSDZBlob);
                                const modelViewer = document.querySelector("#modelViewerStep5 model-viewer");
                                if (modelViewer) { 
                                    modelViewer.setAttribute("ios-src", iosUrl);
                                }
                                // Remove the alert and directly proceed to upload
                                window.goToStep6AndUpload();
                            })
                            .catch(function(e) { alert("Error generating USDZ model: 320" + e); });
                        });
                    } catch (e) { alert("Error generating USDZ model: 322" + e); }
                } else if (window.currentFileType === "glb" && window.uploadedFile) {
                    try {
                        window.createUSDZModelFromGLB(window.uploadedFile, alignment)
                        .then(function(usdzFile) {
                            window.finalUSDZBlob = usdzFile;
                            const iosUrl = URL.createObjectURL(usdzFile);
                            const modelViewer = document.querySelector("#modelViewerStep5 model-viewer");
                            if (modelViewer) { 
                                modelViewer.setAttribute("ios-src", iosUrl);
                            }
                            // Remove the alert and directly proceed to upload
                            window.goToStep6AndUpload();
                        })
                        .catch(function(e) { alert("Error generating USDZ model: 336" + e); });
                    } catch(e) { alert("Error generating USDZ model: 337" + e); }
                } else {
                    alert("No valid file uploaded for USDZ generation.");
                }
            }
        };

        document.getElementById("cancelUploadBtn").onclick = function() {
            if (window.uploadXhr) {
                window.uploadXhr.abort();
                alert("Upload canceled.");
                window.closeModal();
            }
        };

        document.getElementById("addSizeRow").onclick = async function() {
            const modelViewer = document.querySelector("#modelViewerStep5 model-viewer");
            if (modelViewer) {
                try {
                    const defaultDimensions = await window.getModelDimensions(modelViewer);
                    window.addSizeRow(defaultDimensions);
                } catch (error) {
                    console.error('Error getting dimensions:', error);
                    window.addSizeRow({ width: "100.00", height: "100.00", depth: "100.00" });
                }
            } else {
                window.addSizeRow({ width: "100.00", height: "100.00", depth: "100.00" });
            }
        };

        var defaultRemove = document.querySelector("#sizeRowsContainer .size-row .removeSizeRow");
        if(defaultRemove) { defaultRemove.style.display = "none"; }

        // Add initial "No items" message if table is empty
        const tableBody = document.querySelector('#uploadedModelsTable tbody');
        if (tableBody && !tableBody.hasChildNodes()) {
            const noItems = document.createElement('tr');
            noItems.className = 'no-items';
            noItems.innerHTML = '<td colspan="5">No models uploaded yet.</td>';
            tableBody.appendChild(noItems);
        }

        // Add event listener to form submission
        const form = document.querySelector('form');
        if (form) {
            form.addEventListener('submit', function(e) {
                const variants = Array.from(document.querySelectorAll('#uploadedModelsTable tbody tr:not(.no-items)')).map((row, index) => {
                    const url = row.querySelector('.previewBtn').dataset.url;
                    const fileType = row.cells[1].textContent;
                    const sizes = JSON.parse(row.dataset.sizes || '[]');
                    
                    // Get the stored result URLs from the row's data attributes
                    const iosUrl = row.dataset.usdzUrl || '';
                    const posterFileUrl = row.dataset.posterFileUrl ?? row.dataset.posterFileUrl;
                    
                    return {
                        name: `Variant ${index + 1}`,
                        model: (index + 1).toString(),
                        iosUrl: iosUrl,
                        posterFileUrl: posterFileUrl,
                        placement: fileType === 'Model' ? 'floor' : 'wall',
                        sizes: sizes,
                        url: url
                    };
                });
                
                document.getElementById('variantsData').value = JSON.stringify(variants);
            });
        }

        // If editing, populate the table with existing variants
        <?php if (isset($is_edit) && $is_edit && !empty($record['variants'])): ?>
        try {
            // Ensure proper JSON encoding of the variants data
            const existingVariantsNonDecoded = <?php echo json_encode($record['variants']); ?>;
            const existingVariants = JSON.parse(existingVariantsNonDecoded.replace(/\\"/g, '"'));
            if (Array.isArray(existingVariants)) {
                existingVariants.forEach(variant => {
                    const newModel = {
                        fileType: variant.placement === 'floor' ? 'Model' : 'Image',
                        sizes: variant.sizes || [],
                        url: variant.url,
                        androidId: variant.androidId || '',
                        iosUrl: variant.iosUrl || '',
                        iosId: variant.iosId || '',
                        posterFileUrl: variant.posterFileUrl || variant.posterFileUrl,
                        posterFileId: variant.posterFileId || ''
                    };
                    window.addModelToTable(newModel);
                });
            }
        } catch (e) {
            console.error('Error parsing variants:', e);
            console.log('Raw variants data:', <?php echo json_encode($record['variants']); ?>);
        }
        <?php endif; ?>
    });
</script>
