<?php
/**
 * AR Display Form Page Template
 *
 * @package    AR_Display
 * @subpackage AR_Display/admin/partials
 */

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    exit;
}

// Check user capabilities
if (!current_user_can('manage_options')) {
    return;
}

if (!class_exists('AR_Display_3D_Model')) {
    require_once AR_DISPLAY_PLUGIN_DIR . 'admin/class-ardisplay-3d-model.php';
}



$action = isset($_GET['action']) ? sanitize_text_field($_GET['action']) : 'create';
$is_edit = ('edit' === $action && isset($_GET['id']));
$record = array(
    'id'             => '',
    'title'          => '',
    'description'    => '',
    'addToCartUrl' => '',
    'model_url'      => '',
    'variants'       => '[]'
);

if ($is_edit && isset($_GET['id'])) {
    $model_id = sanitize_text_field($_GET['id']);
    
    // Get model data using the 3D Model class
    $model_handler = new AR_Display_3D_Model();
    $api_response = $model_handler->get_model_data($model_id);
    
    if (!is_wp_error($api_response)) {
        // API response is already decoded into an array by the get_model_data method
        
        if (is_array($api_response)) {
            // Map API fields to our record structure
            $record = array(
                'id'             => isset($_GET['id']) ? $_GET['id'] : '',
                'title'          => isset($api_response['title']) ? $api_response['title'] : '',
                'description'    => isset($api_response['description']) ? $api_response['description'] : '',
                'addToCartUrl'=> isset($api_response['addToCartUrl']) ? $api_response['addToCartUrl'] : '',
                'model_url'      => isset($api_response['url']) ? $api_response['url'] : null,
                'variants'       => isset($api_response['options']) ? json_encode($api_response['options']) : '[]'
            );
        } else {
            echo '<div style="margin-left: 0;" class="notice notice-error"><p>Error processing API response data: not a valid array.</p></div>';
        }
    } else {
        echo '<div style="margin-left: 0;" class="notice notice-error"><p>Failed to retrieve data from API: ' . esc_html($api_response->get_error_message()) . '</p></div>';
    }
}
?>
<script type="importmap">
    {
        "imports": {
            "three": "https://unpkg.com/three@0.174.0/build/three.module.js",
            "three/examples/jsm/loaders/GLTFLoader.js": "https://unpkg.com/three@0.174.0/examples/jsm/loaders/GLTFLoader.js",
            "three/examples/jsm/loaders/DRACOLoader.js": "https://unpkg.com/three@0.174.0/examples/jsm/loaders/DRACOLoader.js"
        }
    }
</script>
<div style="width: 98%; max-width: 100%; margin-top: 20px;">

    <div class="ar-form-header">
        <h1><?php echo $is_edit ? 'Edit' : 'Create'; ?> AR Display Model</h1>
    </div>
    
    <form method="post" action="">
        <?php if ($is_edit) : ?>
            <input type="hidden" name="record_id" value="<?php echo esc_attr($record['id']); ?>">
        <?php endif; ?>
        <?php if (isset($_GET['product_id'])) : ?>
            <input type="hidden" name="product_id" value="<?php echo esc_attr($_GET['product_id']); ?>">
        <?php endif; ?>

        <input type="hidden" name="variants" id="variantsData" value="<?php echo esc_attr(isset($record['variants']) ? $record['variants'] : '[]'); ?>">
        
        <div class="ar-form-section">
            <h2>General Information</h2>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row"><label for="model_title">Title</label></th>
                    <td><input type="text" id="model_title" name="model_title" value="<?php echo esc_attr($record['title']); ?>" class="regular-text" /></td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="model_description">Description</label></th>
                    <td><textarea id="model_description" name="model_description" rows="5" class="large-text"><?php echo esc_textarea($record['description']); ?></textarea></td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="model_url">URL</label></th>
                    <td><input type="url" id="model_url" name="model_url" value="<?php echo esc_attr($record['model_url']); ?>" class="regular-text" /></td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="addToCartUrl">Add to Cart URL</label></th>
                    <td><input type="url" id="addToCartUrl" name="addToCartUrl" value="<?php echo esc_attr($record['addToCartUrl']); ?>" class="regular-text" /></td>
                </tr>
            </table>
        </div>
        
        <div class="ar-form-section">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <h2>3D Models</h2>
                <button type="button" id="add-3d-model" class="button">Add 3D Model</button>
            </div>
            <table id="uploadedModelsTable">
                <thead>
                    <tr>
                        <th style="width:5%">ID</th>
                        <th style="width:15%">File Type</th>
                        <th style="width:35%">Sizes</th>
                        <th style="width:20%">Preview</th>
                        <th style="width:25%">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="no-items">
                        <td colspan="5">No models uploaded yet.</td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div class="form-footer">
            <a href="<?php echo admin_url('admin.php?page=ardisplay'); ?>" class="button button-secondary">Cancel</a>
            <button type="button" id="save_model_btn" class="button button-primary">Save Model</button>
        </div>
    </form>
</div>
<!-- admin\partials\ardisplay-admin-configure-ar\templates\modals.php -->

<?php require_once AR_DISPLAY_PLUGIN_DIR . 'admin/partials/ardisplay-admin-configure-ar/templates/modals.php'; ?>
<?php require_once AR_DISPLAY_PLUGIN_DIR . 'admin/partials/ardisplay-admin-configure-ar/js/form-scripts.php'; ?>

<!-- Initialize the 3D models table with variants data -->
<script type="module">
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize the model counter
        window.modelCounter = 0;
        
        // Get variants data from the hidden input
        const variantsData = document.getElementById('variantsData');
        if (variantsData && variantsData.value) {
            try {
                const variants = JSON.parse(variantsData.value);
                
                // If we have variants, populate the table
                if (variants && variants.length > 0) {
                    variants.forEach(variant => {
                        // Map variant fields based on the Prisma schema structure
                        // Create a model object from the variant data
                        const model = {
                            fileType: 'glb',
                            name: variant.name || '', 
                            url: variant.modelUrl || variant.model3dUrl || '',
                            usdzUrl: variant.iosModelUrl || '',
                            iosId: variant.iosId || '',
                            androidId: variant.androidId || '',
                            posterFileUrl: variant.posterFileUrl || variant.posterImageUrl || '',
                            posterFileId: variant.posterFileId || '',
                            placement: variant.placement || 'floor',
                            sizes: variant.sizes || []
                        };
                        
                        // Only add to table if we have a valid model URL
                        if (model.url) {
                            // Add the model to the table
                            window.addModelToTable(model);
                        }
                    });
                }
            } catch (e) {
                console.error('Error initializing variants data:', e);
            }
        }
    });
</script>
